/////////////////////////////////////////////////////////////
// CINEMA SDK : SCENEHOOK																	 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_SCENEHOOKPLUGIN_H
#define __C4D_SCENEHOOKPLUGIN_H

#include "ge_math.h"
#include "c4d_scenehookdata.h"
#include "c4d_nodeplugin.h"

#define SCENEHOOKEXECUTION_ANIMATION			(1<<1)
#define SCENEHOOKEXECUTION_EXPRESSION			(1<<2)
#define SCENEHOOKEXECUTION_CACHEBUILDING	(1<<3)
#define SCENEHOOKEXECUTION_CAMERAONLY			(1<<4)
#define SCENEHOOKEXECUTION_INDRAG					(1<<5)

struct SCENEHOOKPLUGIN : public NODEPLUGIN
{
	public:
		LONG	draw_priority;

		Bool	(SceneHookData::*MouseInput			)(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, EditorWindow *win, const BaseContainer &msg);
		Bool  (SceneHookData::*GetCursorInfo	)(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, Real x, Real y, BaseContainer &bc);
		Bool  (SceneHookData::*Draw						)(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, BaseDrawHelp *bh, BaseThread *bt,LONG flags);

		Bool	(SceneHookData::*AddToExecution )(PluginSceneHook *node, PriorityList *list);
		LONG	(SceneHookData::*InitSceneHook	)(PluginSceneHook *node, BaseDocument *doc, BaseThread *bt);
		void	(SceneHookData::*FreeSceneHook	)(PluginSceneHook *node, BaseDocument *doc);
		LONG	(SceneHookData::*Execute				)(PluginSceneHook *node, BaseDocument *doc, BaseThread *bt, LONG priority, LONG flags);

		void*	reserved[(32-7)*C4DPL_MEMBERMULTIPLIER-1];
};

#endif
